% Keithley KPCI-3108
% Ananlog Trigger 
% This example gathers data on Ch0,1,2
fprintf('Connect the Analog Trigger line to (Ch0) Pin 33 of STP-36') 
% 1. create device object
    ai = analoginput('keithley',0); 
% 2. Add channels
    ch = addchannel(ai,0:2);
    set(ch,'InputRange',[-5 5])
% 3. Configure property values 
    sfreq = 4000;
    nPoints = 1000;
    set(ai,'SampleRate',sfreq)
    set(ai,'SamplesPerTrigger',nPoints) 

%4. Configure for Analog Trigger
    %The channel skew is automatically calculated 
    %as [(sampling rate)(number of channels)] ^ -1.
    set(ai,'ChannelSkewMode','Equisample')
    set(ai,'TriggerChannel',ch(1))
    set(ai,'TriggerType','Software')    %Analog trigger
    set(ai,'TriggerCondition','Rising') 
    set(ai,'TriggerConditionValue',2)   %threshold V
    set(ai,'Timeout',10)                %set the timeout in secs
%5. Get data   
    start(ai)
    [data,time] = getdata(ai);
    
%6. Plot Data
    subplot(3,1,1)
    plot(time(1:50),data(1:50,1),'r'),ylabel('Ch0: Ch (V)'),title('KPCI-3108: Analog Trigger of 1V(rising) on CH 0') 
    subplot(3,1,2)
    plot(time(1:50),data(1:50,2),'b'),ylabel('Ch1 (V)') 
    subplot(3,1,3)
    plot(time(1:50),data(1:50,3),'m'),ylabel('Ch2 (V)'),xlabel('relative time(sec)') 

%7. clear the memory
    delete(ai)  
    clear ai    
    clear all